<?php
/**
 * Class TotalOverallDimensions
 *
 * @package WPDesk\FS\TableRate\Rule\Condition
 */

namespace WPDesk\FS\TableRate\Rule\Condition\Pro;

use WPDesk\FS\TableRate\Rule\Condition\AbstractCondition;

/**
 * Total Overall Dimensions condition.
 */
class TotalOverallDimensions extends AbstractCondition {

	const CONDITION_ID = 'total_overall_dimensions';

	/**
	 * Product constructor.
	 *
	 * @param int $priority .
	 */
	public function __construct( int $priority = 10 ) {
		$this->condition_id = self::CONDITION_ID;
		$this->name         = __( 'Total overall dimensions', 'flexible-shipping' );
		$this->group        = __( 'Weight & Dimensions', 'flexible-shipping' );
		$this->priority     = $priority;
		$this->is_disabled  = true;

		$this->name .= ' ' . __( '(PRO feature)', 'flexible-shipping' );
	}
}
